<?php
/**
 *	Copyright © 2009 DragonFever, df [at] dragonfever [dot] info
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation, either version 3 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

if(!defined("IN_MYBB"))
{
    die("This file cannot be accessed directly.");
}

$plugins->add_hook('index_start', 'todaystopposters_add', 1000000);

function todaystopposters_info()
{
	return array(
		"name"			=>	"Today's Top Posters",
		"description"	=>	"Show the users that posted the most within 24 hours on forum index.",
		"website"		=>  "http://www.dragonfever.info",
		"author"		=>  "DragonFever",
		"authorsite"	=>  "http://www.dragonfever.info",
		"version"		=>  "1.0",
		"guid"			=>	"d44eb3942b186ce5231b43a20d97196f",
		"compatibility" =>	"16*",
	);
}

function todaystopposters_activate()
{
	global $db;

	$hidelinks_group = array(
		"gid"			=> "NULL",
		"name"			=> "todaystopposters",
		"title" 		=> "Today\'s Top Posters",
		"description"	=> "Settings for Today\'s Top Posters plugin.",
		"disporder"		=> "100",
		"isdefault"		=> "no",
	);
	$db->insert_query("settinggroups", $hidelinks_group);
	$gid = $db->insert_id();
	
	$hidelinks_setting_1 = array(
		"sid"			=> "NULL",
		"name"			=> "todaystopposters_enabled",
		"title"			=> "Enable/Disable",
		"description"	=> "Enable Today\'s Top Posters plugin?",
		"optionscode"	=> "yesno",
		"value"			=> "no",
		"disporder"		=> "1",
		"gid"			=> intval($gid),
	);
		
    $hidelinks_setting_2 = array(
        "sid"			=> "NULL",
        "name"			=> "todaystopposters_count",
        "title"			=> "Today\'s Top Posters Limit",
        "description"	=> "How many top posters will be displayed?",
        "optionscode"	=> "text",
        "value"			=> "10",
        "disporder"		=> "2",
        "gid"			=> intval($gid),
    );
	
	$db->insert_query("settings", $hidelinks_setting_1);
	$db->insert_query("settings", $hidelinks_setting_2);
	
	// Optimizing database
	$db->query("OPTIMIZE TABLE ".TABLE_PREFIX."settinggroups");
	$db->query("OPTIMIZE TABLE ".TABLE_PREFIX."settings");
	$db->query("OPTIMIZE TABLE ".TABLE_PREFIX."sessions");
	
	// Rebuilding settings
    rebuildsettings();
	
	$template = array(
		"tid"		=> NULL,
		"title"		=> "todays_top_posters_index",
		"template"	=> "<tr>
	<td class=\"tcat\"><strong>{\$lang->todays_top_posters}</strong></td>
</tr>
<tr>
	<td class=\"trow1\"><span class=\"smalltext\">{\$todaystopposters}</span></td>
</tr>",
		"sid"		=> "-1"
	);
	$db->insert_query("templates", $template);
	
	$template = array(
		"tid"		=> NULL,
		"title"		=> "todays_top_posters_index_memberbit",
		"template"	=> "{\$comma}{\$user[\'profilelink\']}{\$postcount}",
		"sid"		=> "-1"
	);
	$db->insert_query("templates", $template);

	require MYBB_ROOT."/inc/adminfunctions_templates.php";
	find_replace_templatesets('index_boardstats', '#{\$whosonline}#', "{\$whosonline}\n{\$todays_top_posters}");
}

function todaystopposters_deactivate()
{
	global $db;
	
	$db->query("DELETE FROM ".TABLE_PREFIX."settinggroups WHERE name='todaystopposters'");
	$db->query("DELETE FROM ".TABLE_PREFIX."settings WHERE name='todaystopposters_enabled'");
	$db->query("DELETE FROM ".TABLE_PREFIX."settings WHERE name='todaystopposters_count'");
	
	// Optimizing database
	$db->query("OPTIMIZE TABLE ".TABLE_PREFIX."settinggroups");
	$db->query("OPTIMIZE TABLE ".TABLE_PREFIX."settings");
	$db->query("OPTIMIZE TABLE ".TABLE_PREFIX."sessions");
	
	// Rebuilding settings
    rebuildsettings();
	
	$db->query("DELETE FROM ".TABLE_PREFIX."templates WHERE title='todays_top_posters_index'");
	$db->query("DELETE FROM ".TABLE_PREFIX."templates WHERE title='todays_top_posters_index_memberbit'");

	require MYBB_ROOT."/inc/adminfunctions_templates.php";

	find_replace_templatesets('index_boardstats', '#(\n?){\$todays_top_posters}#', '', 0);
}

function todaystopposters_add()
{
	global $db, $mybb, $templates, $todays_top_posters, $lang, $theme;
	
	$lang->load("todaystopposters");
	
	if ($mybb->settings['todaystopposters_enabled'] == "1")
	{
		$todays_top_posters = '';
		$limit = $mybb->settings['todaystopposters_count'];
		$comma = '';
		$count = 0;
		$dateline = TIME_NOW - 86400;
		$query = $db->query("SELECT COUNT(post.dateline) AS postcount, post.uid, user.uid, user.username, user.usergroup, user.displaygroup 
		FROM ".TABLE_PREFIX."posts AS post 
		JOIN ".TABLE_PREFIX."users AS user ON (post.uid=user.uid) 
		WHERE dateline > $dateline 
		GROUP BY post.uid 
		ORDER BY postcount DESC 
		LIMIT $limit");
		
		while($ttp = $db->fetch_array($query))
		{
			$count++;
			$user['username'] = format_name($ttp['username'], $ttp['usergroup'], $ttp['displaygroup']);
			$user['profilelink'] = build_profile_link($user['username'], $ttp['uid']);
			$postcount = " (".$ttp['postcount'].")";
			eval("\$todaystopposters .= \"".$templates->get("todays_top_posters_index_memberbit", 1, 0)."\";");
			$comma = ", ";
		}
		
		if($count == "0")
		{
			$todaystopposters = $lang->todays_top_posters_none;
		}
		
		$lang->todays_top_posters = $lang->sprintf($lang->todays_top_posters, my_number_format($limit));
		eval("\$todays_top_posters = \"".$templates->get("todays_top_posters_index")."\";");
	}
}
?>